<?php

namespace App\Models\Modele;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Modele extends Model 
{

    protected $table = 'modeles';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function vehicules()
    {
        return $this->hasMany('App\Models\Vehicule\Vehicule');
    }

    public function marque()
    {
        return $this->belongsTo('App\Models\Marque\Marque');
    }

}